Public Class Intouch
    Public ExitFlag As Boolean = False
    Private hWnd, xStorage As Integer
    Public Sub New(ByVal _hWnd As Integer, ByVal _xStorage As Integer)
        ''Set defaults
        hWnd = _hWnd
        xStorage = _xStorage
    End Sub
    Public Function ReadInteger(ByVal TagName As String) As Integer
        'Returns the current value of an InTouch INTEGER variable.

        Dim accid As Integer
        Dim hPt As Integer

        'This calls wwHeap_Register - This must be called before any PtAcc calls.
        wwHeap_Register(0, 0)

        'This initializes Ptacc.dll
        accid = PtAccInit(hWnd, xStorage)

        If accid = 0 Then
            ExitFlag = True
        Else
            'This code reads in the tagnames 
            hPt = PtAccActivate(accid, TagName)
            ReadInteger = PtAccReadI(accid, hPt)
            'This shuts down Ptacc.dll
            PtAccShutdown(accid)
        End If

    End Function
    Public Function ReadDiscrete(ByVal TagName As String) As Integer
        'Returns the current value of an InTouch DISCRETE variable.

        Dim accid As Integer
        Dim hPt As Integer

        'This calls wwHeap_Register - This must be called before any PtAcc calls.
        wwHeap_Register(0, 0)

        'This initializes Ptacc.dll
        accid = PtAccInit(hWnd, xStorage)

        If accid = 0 Then
            ExitFlag = True
        Else
            'This code reads in the tagnames 
            hPt = PtAccActivate(accid, TagName)
            ReadDiscrete = PtAccReadD(accid, hPt)
            'This shuts down Ptacc.dll
            PtAccShutdown(accid)
        End If

    End Function
    Public Function ReadFloat(ByVal TagName As String) As Single
        'Returns the current value of an InTouch FLOATING point variable.

        Dim accid As Integer
        Dim hPt As Integer

        'This calls wwHeap_Register - This must be called before any PtAcc calls.
        wwHeap_Register(0, 0)

        'This initializes Ptacc.dll
        accid = PtAccInit(hWnd, xStorage)

        If accid = 0 Then
            ExitFlag = True
        Else
            'This code reads in the tagnames 
            hPt = PtAccActivate(accid, TagName)
            ReadFloat = PtAccReadR(accid, hPt)
            'This shuts down Ptacc.dll
            PtAccShutdown(accid)
        End If

    End Function
    Public Function ReadDIF(ByVal TagName As String) As Double
        'Returns the current value of an InTouch DISCRETE, INTEGER or FLOATING point variable.

        Dim accid As Integer
        Dim hPt As Integer

        'This calls wwHeap_Register - This must be called before any PtAcc calls.
        wwHeap_Register(0, 0)

        'This initializes Ptacc.dll
        accid = PtAccInit(hWnd, xStorage)

        If accid = 0 Then
            ExitFlag = True
        Else
            'This code reads in the tagnames 
            hPt = PtAccActivate(accid, TagName)
            ReadDIF = PtAccReadA(accid, hPt)
            'This shuts down Ptacc.dll
            PtAccShutdown(accid)
        End If

    End Function
    Public Function ReadString(ByVal strTagName As String, ByVal intStringLength As Integer) As String
        'Returns the current value of an InTouch STRING variable.

        Dim accid As Integer
        Dim hPt As Integer
        Dim strStringTag As String = Space(intStringLength)

        'This calls wwHeap_Register - This must be called before any PtAcc calls.
        wwHeap_Register(0, 0)

        'This initializes Ptacc.dll
        accid = PtAccInit(hWnd, xStorage)

        If accid = 0 Then
            ExitFlag = True
        Else
            'This code reads in the tagnames 
            hPt = PtAccActivate(accid, strTagName)
            ReadString = PtAccReadM(accid, hPt, strStringTag, intStringLength)
            ReadString = Trim(strStringTag)
            'This shuts down Ptacc.dll
            PtAccShutdown(accid)
        End If

    End Function
    Public Sub WriteInteger(ByVal TagName As String, ByVal Value As Integer)
        'Sets a new value into an InTouch INTEGER variable.

        Dim accid As Integer
        Dim hPt As Integer

        'This calls wwHeap_Register - This must be called before any PtAcc calls.
        wwHeap_Register(0, 0)

        'This initializes Ptacc.dll
        accid = PtAccInit(0, 0)

        If accid = 0 Then
            ExitFlag = True
        Else
            'This code writes value to "TagName"
            hPt = PtAccActivate(accid, TagName)
            PtAccWriteI(accid, hPt, Value)
            'This shuts down Ptacc.dll
            PtAccShutdown(accid)
        End If

    End Sub
    Public Sub WriteDiscrete(ByVal TagName As String, ByVal Value As Integer)
        'Sets a new value into an InTouch DISCRETE variable.

        Dim accid As Integer
        Dim hPt As Integer

        'This calls wwHeap_Register - This must be called before any PtAcc calls.
        wwHeap_Register(0, 0)

        'This initializes Ptacc.dll
        accid = PtAccInit(0, 0)

        If accid = 0 Then
            ExitFlag = True
        Else
            'This code writes value to "TagName"
            hPt = PtAccActivate(accid, TagName)
            PtAccWriteD(accid, hPt, Value)
            'This shuts down Ptacc.dll
            PtAccShutdown(accid)
        End If

    End Sub
    Public Sub WriteFloat(ByVal TagName As String, ByVal Value As Single)
        'Sets a new value into an InTouch FLOATING point variable.

        Dim accid As Integer
        Dim hPt As Integer

        'This calls wwHeap_Register - This must be called before any PtAcc calls.
        wwHeap_Register(0, 0)

        'This initializes Ptacc.dll
        accid = PtAccInit(0, 0)

        If accid = 0 Then
            ExitFlag = True
        Else
            'This code writes value to "TagName"
            hPt = PtAccActivate(accid, TagName)
            PtAccWriteR(accid, hPt, Value)
            'This shuts down Ptacc.dll
            PtAccShutdown(accid)
        End If

    End Sub
    Public Sub WriteDIF(ByVal TagName As String, ByVal Value As Double)
        'Sets a new value into an InTouch DISCRETE, INTEGER or FLOATING point variable.

        Dim accid As Integer
        Dim hPt As Integer

        'This calls wwHeap_Register - This must be called before any PtAcc calls.
        wwHeap_Register(0, 0)

        'This initializes Ptacc.dll
        accid = PtAccInit(0, 0)

        If accid = 0 Then
            ExitFlag = True
        Else
            'This code writes value to "TagName"
            hPt = PtAccActivate(accid, TagName)
            PtAccWriteA(accid, hPt, Value)
            'This shuts down Ptacc.dll
            PtAccShutdown(accid)
        End If

    End Sub
    Public Sub WriteString(ByVal TagName As String, ByVal Value As String)
        'Sets a new value into an InTouch STRING variable.

        Dim accid As Integer
        Dim hPt As Integer

        'This calls wwHeap_Register - This must be called before any PtAcc calls.
        wwHeap_Register(0, 0)

        'This initializes Ptacc.dll
        accid = PtAccInit(0, 0)


        If accid = 0 Then
            ExitFlag = True
        Else
            'This code writes value to "TagName"
            hPt = PtAccActivate(accid, TagName)
            PtAccWriteM(accid, hPt, Value)
            'This shuts down Ptacc.dll
            PtAccShutdown(accid)
        End If

    End Sub
End Class
